/*
 * Copyright (C) Sergey P. Derevyago, 2000-2004.
 *
 * Permission to copy, use, modify, sell and distribute this software is granted
 * provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied warranty, and
 * with no claim as to its suitability for any purpose.
 *
 */

#include <stdio.h>
#include <string.h>

struct A {
       static const int nsize=10;
       static int tmpcount;

       int val;
       char n[nsize];

       A(int val_) : val(val_)  //    
       {
        sprintf(n, "_%d", ++tmpcount);
        printf("%5s.A::A(int %d)\n", n, val);
       }

       A(char cn, int val_) : val(val_)
       {
        n[0]=cn;
        n[1]=0;
        
        printf("%5s.A::A(char, int %d)\n", n, val);
       }

       A(const A& a) : val(a.val)
       {
        if (strlen(a.n)<=nsize-2) {
           n[0]='?';
           strcpy(n+1, a.n);
        }
        else strcpy(n, "");
        
        printf("%5s.A::A(const A& %s)\n", n, a.n);
       }

       ~A() { printf("%5s.A::~A()\n", n); }

       A& operator=(const A& a)
       {
        val=a.val;

        if (strlen(a.n)<=nsize-2) {
           n[0]='=';
           strcpy(n+1, a.n);
        }
        else strcpy(n, "");
        
        printf("%5s.A::operator=(const A& %s)\n", n, a.n);
        return *this;
       }

       friend A operator+(const A& a1, const A& a2)
       {
        printf("operator+(const A& %s, const A& %s)\n", a1.n, a2.n);
        return A(a1.val+a2.val);
       }
};

int A::tmpcount;

int main()
{
 A a('a', 1), b('b', 2), c('c', 3);
 A d=a+b+c;
 printf("d  %s\n", d.n);
 printf("d.val=%d\n", d.val);

 /* 
 A a('a', 1), b('b', 2), c('c', 3);
 A d('d', 0);
 d=a+b+c;
 printf("d  %s\n", d.n);
 printf("d.val=%d\n", d.val);
 */
}

